﻿package {
	
	import flash.display.Sprite;
	import flash.display.Shape;
	import flash.display.SimpleButton;
	import flash.display.GradientType;
	import flash.text.TextField;
	import flash.text.TextFieldType;
	import flash.text.TextFormat;
	import flash.text.TextFormatAlign;
	import flash.geom.Matrix;
	
	
	/**
	 * @author necoEngine bamboo-satellites
	 * @version 
	 * @see http://www.bamboo-satellites.com/
	 * 
	 * 機能：
	 * インスタンス化の時にコンストラクタに渡す引数の文字列でボタンインスタンスを作成する。
	 * ボタンのサイズや色など見栄えにかかわる仕様は全て限定。
	 * ボタンの色を変える機能があるが、変更する色は限定。
	 */
	public class ButtonCreater extends SimpleButton {
		
		private const FONT_SIZE:int  = 10;
		private const FONT_COLOR:int = 0x7A5B52
		private const PADDING_W:int  = 20;
		private const PADDING_H:int  = 6;
		
		private const DOWN_HIGHLIGHT:int = 0xFFFFFF;
		private const UP_HIGHLIGHT:int   = 0xFFFFCC;
		private const OVER_HIGHLIGHT:int = 0xFFFFCC;
		private const DIS_HIGHLIGHT:uint = 0xEEEEEE;
		private const DOWN_SHADOW:int = 0xFFFF99;
		private const UP_SHADOW:int   = 0xFF9900;
		private const OVER_SHADOW:int = 0xFFCC66;
		private const DIS_SHADOW:uint = 0xAAAAAA;
		private const RECT_ANGLE:int = 14;
		
		private var buttonString:String;
		
		
		public function ButtonCreater(str:String = ""):void {
			
			buttonString = str;
			
			upState      = buttonStructure(UP_HIGHLIGHT,   UP_SHADOW);
			downState    = buttonStructure(DOWN_HIGHLIGHT, DOWN_SHADOW);
			overState    = buttonStructure(OVER_HIGHLIGHT, OVER_SHADOW);
			hitTestState = buttonStructure(OVER_HIGHLIGHT, OVER_SHADOW);
			
		} // constructor close
		
		
		private function buttonStructure(highLight:uint, shadow:uint):Sprite {
			
			var sp:Sprite         = new Sprite();
			var tf:TextField      = new TextField();
			var format:TextFormat = new TextFormat();
			
			//TextFormat
			format.color = FONT_COLOR;
			format.size  = FONT_SIZE;
			format.font  = "Verdana";
			format.bold  = true;
			format.align = TextFormatAlign.CENTER;
			format.letterSpacing = -0.5;
			
			//TextField
			tf.defaultTextFormat = format;
			tf.text = buttonString;
			
			tf.type   = TextFieldType.DYNAMIC;
			tf.width  = tf.textWidth  + PADDING_W;
			tf.height = tf.textHeight + PADDING_H;
			tf.x = 0;
			tf.y = 1;
			tf.selectable = false;
			
			//ボタン背景描画
			var gColor:Array   = [highLight, shadow];
			var gAlpha:Array   = [1, 1];
			var gRatio:Array   = [0, 255];
			var gMatrix:Matrix = new Matrix();
			gMatrix.createGradientBox(tf.textWidth + PADDING_W, tf.textHeight + PADDING_H, Math.PI / 2);
			
			sp.graphics.lineStyle(1, 0xAAAAAA, 1, true);
			sp.graphics.beginGradientFill(GradientType.LINEAR, gColor, gAlpha, gRatio, gMatrix);
			sp.graphics.drawRoundRect(0, 0, tf.textWidth + PADDING_W, tf.textHeight + PADDING_H, RECT_ANGLE);
			sp.graphics.endFill();
			
			sp.addChild(tf);
			
			return sp;
			
		} // buttonStructure() close
		
		
		public function activeShifter(active:Boolean = true):void {
			/**
			 * 機能：ボタンインスタンスの色をグレー表示に変える
			 * 引数：アクティブ表示にするかグレー表示にするかの指示。省略するとアクティブ表示
			 * 戻り値：なし
			 * 備考：ホントはカラー成分を取って任意の色に変更すれば良さ気
			 */
			
			if (active) {
				upState      = buttonStructure(UP_HIGHLIGHT,   UP_SHADOW);
				downState    = buttonStructure(DOWN_HIGHLIGHT, DOWN_SHADOW);
				overState    = buttonStructure(OVER_HIGHLIGHT, OVER_SHADOW);
				hitTestState = buttonStructure(OVER_HIGHLIGHT, OVER_SHADOW);
			} else {
				upState      = buttonStructure(DIS_HIGHLIGHT, DIS_SHADOW);
				downState    = buttonStructure(DIS_HIGHLIGHT, DIS_SHADOW);
				overState    = buttonStructure(DIS_HIGHLIGHT, DIS_SHADOW);
				hitTestState = buttonStructure(DIS_HIGHLIGHT, DIS_SHADOW);
			}
			
		} // activeShifter() close
		
		
		public function onOffShifter(on:Boolean = true):void {
			/**
			 * 機能：機能オン/オフ時のカラー切り替え
			 * 引数：アクティブ表示にするかグレー表示にするかの指示。省略するとアクティブ表示
			 * 戻り値：なし
			 * 備考：ホントはカラー成分を取って任意の色に変更すれば良さ気
			 */
			
			if (on) {
				upState      = buttonStructure(UP_HIGHLIGHT,   UP_SHADOW);
				downState    = buttonStructure(DOWN_HIGHLIGHT, DOWN_SHADOW);
				overState    = buttonStructure(OVER_HIGHLIGHT, OVER_SHADOW);
				hitTestState = buttonStructure(OVER_HIGHLIGHT, OVER_SHADOW);
			} else {
				upState      = buttonStructure(DIS_HIGHLIGHT, DIS_SHADOW);
				downState    = buttonStructure(DIS_HIGHLIGHT, DIS_SHADOW);
				overState    = buttonStructure(0xFFFFFF,      0xFFFFFF);
				hitTestState = buttonStructure(DIS_HIGHLIGHT, DIS_SHADOW);
			}
			
		} // onOffShifter() close
	}
}