﻿package {
	
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.geom.Point;
	import flash.utils.Timer;
	
	
	/**
	 *  ...
	 * 
	 * @author necoEngine bamboo-satellites
	 * @version 
	 * @see http://www.bamboo-satellites.com/
	 */
	public class DataStructure {
		
		private var fieldData:Vector.<Vector.<int>>;      // フィールドの状態を常に保存しておく配列
		private var fieldContainer:Shape;                 // フィールドのデータを元に状態を描画する表示コンテナ
		private var dropTetromino:Vector.<Vector.<uint>>; // 落下中のテトリミノのパターンデータ
		private var dropLocation:Point;                   // 落下中のテトリミノの位置情報
		private var ghostY:int;                           // ゴーストブロックを描画するy座標位置情報
		private var dropTimer:Timer;                      // テトリミノの自動落下用タイマーオブジェクト
		
		private var dropAccel:int;                        // テトリミノの自動落下の加速値（deleyプロパティから減算する値）
		private var dropCount:uint;                       // テトリミノが落下した回数を数えるカウンタ（加速度の更新に使用）
		private var status:uint;                          // セッションステータスのビットマスクフラグ
		
		private var dropHandler:Function;                 // 自動落下用タイマーオブジェクトに登録する、リスナー関数
		private var keyHandler:Function;                  // キーボードイベントのリスナー関数
		
		
//================================================================================
// public
//================================================================================
		public function dataClear():void {
			/**
			 * 機能：保持していたデータを削除する
			 * 引数：なし
			 * 戻り値：なし
			 * 備考：
			 */
			
			fieldData.forEach(function (element:Vector.<int>, index:int, array:Vector.<Vector.<int>>):void { element = null; } );
			fieldData = null;
			dropLocation = null;
			dropTetromino.forEach(function (element:Vector.<uint>, index:int, array:Vector.<Vector.<uint>>):void { element = null;} );
			dropTetromino = null;
			
			dropTimer   = null;
			dropHandler = null;
			keyHandler  = null;
			status      = 0;
			
		} // dataClear() close
		
		
		//------------------------------------------------------------
		// setter
		//------------------------------------------------------------
		public function set _field(v:Vector.<Vector.<int>>):void      { fieldData      = v; }
		public function set _container(s:Shape):void                  { fieldContainer = s; }
		public function set _tetromino(v:Vector.<Vector.<uint>>):void { dropTetromino  = v; }
		public function set _location(p:Point):void                   { dropLocation   = p; }
		public function set _ghostY(i:int):void                       { ghostY         = i; }
		public function set _timer(t:Timer):void                      { dropTimer      = t; }
		
		public function set _dropAccel(i:int):void                    { dropAccel      = i; }
		public function set _dropCount(u:uint):void                   { dropCount      = u; }
		public function set _status(u:uint):void                      { status         = u; }
		
		public function set _dropHandler(f:Function):void             { dropHandler    = f; }
		public function set _keyHandler(f:Function):void              { keyHandler     = f; }
		
		
		//------------------------------------------------------------
		// getter
		//------------------------------------------------------------
		public function get _field():Vector.<Vector.<int>>      { return fieldData;      }
		public function get _container():Shape                  { return fieldContainer; }
		public function get _tetromino():Vector.<Vector.<uint>> { return dropTetromino;  }
		public function get _location():Point                   { return dropLocation;   }
		public function get _ghostY():int                       { return ghostY;         }
		public function get _timer():Timer                      { return dropTimer;      }
		
		public function get _dropAccel():int                    { return dropAccel;      }
		public function get _dropCount():uint                   { return dropCount;      }
		public function get _status():uint                      { return status;         }
		
		public function get _dropHandler():Function             { return dropHandler;    }
		public function get _keyHandler():Function              { return keyHandler;     }
	}
}